package es.uvigo.esei.dai.ws.calculator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import javax.xml.namespace.QName;

import es.uvigo.esei.dai.ws.calculator.adapters.NamedOperations;
import es.uvigo.esei.dai.ws.calculator.adapters.NamedResults;
import jakarta.xml.ws.Service;

public class CalculatorServiceClient {
	public static void main(String[] args) throws MalformedURLException {
		final URL url = new URL("http://localhost:9876/calculator?wsdl");
		
		final QName name = new QName(
			"http://calculator.ws.dai.esei.uvigo.es/",
			"CalculatorServiceImplService"
		);
		
		final Service service = Service.create(url, name);
		
		final CalculatorService calculator = service.getPort(CalculatorService.class);
		
		System.out.println("Basic methods results");
		System.out.println(calculator.add(20d, 30d));
		System.out.println(calculator.subtract(20d, 30d));
		System.out.println(calculator.multiply(20d, 30d));
		System.out.println(calculator.divide(20d, 30d));
		
		System.out.println("\nOperate results");
		System.out.println(calculator.operate(Operation.ADD, 20d, 30d));
		System.out.println(calculator.operate(Operation.SUB, 20d, 30d));
		System.out.println(calculator.operate(Operation.MUL, 20d, 30d));
		System.out.println(calculator.operate(Operation.DIV, 20d, 30d));
		
		System.out.println("\nCollections results");
		System.out.println("Serial: " + calculator.serialOperate(Operation.ADD, 10d, 20d, 30d));
		System.out.println("Array: " + calculator.arrayOperate(Operation.ADD, new double[]{10d, 20d, 30d}));
		System.out.println("List: " + calculator.listOperate(Operation.ADD, Arrays.asList(10d, 20d, 30d)));
		
		System.out.println("\nMap results");
		final Map<String, Operation> operations = new HashMap<String, Operation>();
		for (Operation operation : Operation.values()) {
			operations.put(operation.name(), operation);
		}
		
		final NamedResults results = calculator.mapOperate(
			new NamedOperations(operations), 20d, 30d
		);
		for (Map.Entry<String, Double> entry : results.getResults().entrySet()) {
			System.out.println(entry.getKey() + ": " + entry.getValue());
		}
		
		System.out.println("\nException");
		try {
			System.out.println(calculator.divide(20d, 0d));
		} catch (CalculatorException e) {
			e.printStackTrace();
		}
	}
}
