package es.uvigo.esei.dai.ws.calculator;

import java.util.Collection;

import es.uvigo.esei.dai.ws.calculator.adapters.NamedOperations;
import es.uvigo.esei.dai.ws.calculator.adapters.NamedResults;
import jakarta.jws.WebMethod;
import jakarta.jws.WebService;

@WebService
public interface CalculatorService {
	@WebMethod
	public double add(double op1, double op2);
	
	@WebMethod
	public double subtract(double op1, double op2);
	
	@WebMethod
	public double multiply(double op1, double op2);
	
	@WebMethod
	public double divide(double op1, double op2)
	throws CalculatorException;
	
	@WebMethod
	public double operate(Operation operation, double op1, double op2)
	throws CalculatorException;
	
	@WebMethod
	public double serialOperate(Operation operation, double ... op)
	throws CalculatorException;
	
	@WebMethod
	public double arrayOperate(Operation operation, double[] op)
	throws CalculatorException;
	
	@WebMethod
	public double listOperate(Operation operation, Collection<Double> op)
	throws CalculatorException;
	
	/*
	 * JAXB no soporta esta declaración de método porque hace uso de Map,
	 * que es una interfaz y JAXB no es capaz de trabajar con interfaces
	 * directamente.
	 *
	 * @WebMethod
	 * public Map<String, Double> mapOperate(
	 * 		Map<String, Operation> operations, double op1, double op2
	 * ) throws CalculatorException;
	 */
	
	@WebMethod
	public NamedResults mapOperate(
		NamedOperations operations, double op1, double op2
	) throws CalculatorException;
}
