/*-
 * #%L
 * Ejemplos de DAI - Multithilo
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.threads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class EchoClient {
  public static void main(String[] args) {
    // Búfer de entrada por teclado
    final BufferedReader console = new BufferedReader(new InputStreamReader(System.in));

    try (Socket socket = new Socket(InetAddress.getLocalHost(), 50000)) {
      // Conexión con el servidor
      final SocketIOManager ioManager = new SocketIOManager(socket);

      // Bucle principal:
      // 1. Lectura de teclado
      // 2. Envío al servidor
      // 3. Comprobación de finalización
      // 4. Recepción y salida por consola de la respuesta
      String line;
      while ((line = console.readLine()) != null) { // 1
        System.out.println("INPUT: " + line);

        ioManager.println(line); // 2

        if (line.equalsIgnoreCase("quit")) {
          break; // 4
        }

        System.out.println("ECHO: " + ioManager.readLine()); // 3
      }
    } catch (final UnknownHostException e) {
      System.out.println("Unknown host: localhost");
    } catch (final IOException e) {
      System.out.println("Connection error: " + e.getMessage());
    }
  }
}
