/*-
 * #%L
 * DAI Dojo - Kata 6
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.xml.xpath;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.xml.sax.InputSource;

public class XSLUtils {
  public static Object xpathQueryDOM(Object object, String expression, QName qname) throws XPathExpressionException {
    final XPathFactory factory = XPathFactory.newInstance();

    final XPath xpath = factory.newXPath();

    return xpath.evaluate(expression, object, qname);

    /*
     * También sería válido XPathExpression xpExp = xpath.compile(expression); return xpExp.evaluate(object, qname);
     */
  }

  public static Object xpathQuerySAX(InputSource xmlSource, String expression, QName qname)
    throws XPathExpressionException {
    final XPathFactory factory = XPathFactory.newInstance();

    final XPath xpath = factory.newXPath();

    return xpath.evaluate(expression, xmlSource, qname);

    /*
     * También sería válido XPathExpression xpExp = xpath.compile(expression); return xpExp.evaluate(xmlSource, qname);
     */
  }

  public static Object xpathQueryDOM(Object object, String expression, QName returnType, NamespaceContext nsContext)
    throws XPathExpressionException {
    final XPathFactory factory = XPathFactory.newInstance();
    final XPath xpath = factory.newXPath();

    if (nsContext != null) {
      xpath.setNamespaceContext(nsContext);
    }

    return xpath.evaluate(expression, object, returnType);
  }

  public static Object xpathQuerySAX(
    InputSource xmlSource, String expression, QName returnType, NamespaceContext nsContext
  ) throws XPathExpressionException {
    final XPathFactory factory = XPathFactory.newInstance();
    final XPath xpath = factory.newXPath();

    if (nsContext != null) {
      xpath.setNamespaceContext(nsContext);
    }

    return xpath.evaluate(expression, xmlSource, returnType);
  }

  public static void transformWithXSLT(Source xmlSource, Source xsltSource, Result result) throws TransformerException {
    final TransformerFactory tFactory = TransformerFactory.newInstance();
    final Transformer transformer = tFactory.newTransformer(xsltSource);

    transformer.transform(xmlSource, result);
  }

  public static String transformWithXSLT(File xml, File xslt) throws TransformerException, IOException {
    final TransformerFactory tFactory = TransformerFactory.newInstance();
    final Transformer transformer = tFactory.newTransformer(new StreamSource(xslt));

    try (final StringWriter writer = new StringWriter()) {
      transformer.transform(new StreamSource(xml), new StreamResult(writer));

      return writer.toString();
    }
  }

  public static String transformToString(File xml) throws TransformerException, IOException {
    final TransformerFactory tFactory = TransformerFactory.newInstance();
    final Transformer transformer = tFactory.newTransformer();

    try (final StringWriter writer = new StringWriter()) {
      transformer.transform(new StreamSource(xml), new StreamResult(writer));

      return writer.toString();
    }
  }
}
