/*-
 * #%L
 * DAI Dojo - Código base Kata 3
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.kata3.model.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Employee implements Serializable {
  private static final long serialVersionUID = 1L;

  private Integer id;
  private String name;
  private String surname;
  private int salary;
  private Date birth;
  private boolean intern;

  public Employee() {
  }

  public Employee(String name, String surname, Date birth, int salary, boolean intern) {
    this.name = name;
    this.surname = surname;
    this.salary = salary;
    this.birth = birth;
    this.intern = intern;
  }

  public Employee(Integer id, String name, String surname, Date birth, int salary, boolean intern) {
    this.id = id;
    this.name = name;
    this.surname = surname;
    this.birth = birth;
    this.salary = salary;
    this.intern = intern;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getSurname() {
    return surname;
  }

  public void setSurname(String surname) {
    this.surname = surname;
  }

  public int getSalary() {
    return salary;
  }

  public void setSalary(int salary) {
    this.salary = salary;
  }

  public Date getBirth() {
    return birth;
  }

  public void setBirth(Date birth) {
    this.birth = birth;
  }

  public boolean isIntern() {
    return intern;
  }

  public void setIntern(boolean intern) {
    this.intern = intern;
  }
  
  @Override
  public int hashCode() {
    return Objects.hash(birth, id, intern, name, salary, surname);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Employee other = (Employee) obj;
    return Objects.equals(birth, other.birth) && Objects.equals(id, other.id) && intern == other.intern
      && Objects.equals(name, other.name) && salary == other.salary && Objects.equals(surname, other.surname);
  }

  @Override
  public String toString() {
    return "Employee [id=" + id + ", name=" + name + ", surname=" + surname + ", salary=" + salary + ", birth=" + birth
      + ", intern=" + intern + "]";
  }

}
