/*-
 * #%L
 * DAI Dojo - Código base Kata 3
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.kata3.model.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import es.uvigo.esei.dai.kata3.EmployeeNotFoundException;
import es.uvigo.esei.dai.kata3.model.entity.Employee;

public class EmployeesMapDAO implements EmployeesDAO {
  private final Map<Integer, Employee> employees;

  private int idGenerator;

  public EmployeesMapDAO() {
    this.employees = new HashMap<>();

    final Calendar calendar = GregorianCalendar.getInstance();

    this.idGenerator = 1;
    calendar.set(1980, Calendar.FEBRUARY, 10);
    this.create(new Employee("Manuel", "Martínez", calendar.getTime(), 10000, false));
    calendar.set(1975, Calendar.MARCH, 21);
    this.create(new Employee("María", "Muñíz", calendar.getTime(), 12000, true));

  }

  @Override
  public Employee get(int id) throws EmployeeNotFoundException {
    if (this.employees.containsKey(id)) {
      return this.employees.get(id);
    } else {
      throw new EmployeeNotFoundException(id);
    }
  }

  @Override
  public void create(Employee employee) {
    employee.setId(this.idGenerator++);
    this.employees.put(employee.getId(), employee);
  }

  @Override
  public void update(Employee employee) throws EmployeeNotFoundException {
    System.out.println(employee);
    System.out.println(this.employees);
    if (this.employees.containsKey(employee.getId())) {
      this.employees.put(employee.getId(), employee);
      System.out.println(this.employees);
    } else {
      throw new EmployeeNotFoundException(employee.getId());
    }
  }

  @Override
  public void delete(int id) throws EmployeeNotFoundException {
    if (this.employees.remove(id) == null) {
      throw new EmployeeNotFoundException(id);
    }
  }

  @Override
  public List<Employee> list() {
    return new ArrayList<>(this.employees.values());
  }

  @Override
  public List<Employee> listByName(String name) {
    final List<Employee> employees = this.list();

    final Iterator<Employee> itEmployees = employees.iterator();
    while (itEmployees.hasNext()) {
      if (!itEmployees.next().getName().contains(name)) {
        itEmployees.remove();
      }
    }

    return employees;
  }

  @Override
  public List<Employee> listBySurname(String surname) {
    final List<Employee> employees = this.list();

    final Iterator<Employee> itEmployees = employees.iterator();
    while (itEmployees.hasNext()) {
      if (!itEmployees.next().getSurname().contains(surname)) {
        itEmployees.remove();
      }
    }

    return employees;
  }

  @Override
  public List<Employee> listBySalary(int minimumSalary) {
    final List<Employee> employees = this.list();

    final Iterator<Employee> itEmployees = employees.iterator();
    while (itEmployees.hasNext()) {
      if (itEmployees.next().getSalary() < minimumSalary) {
        itEmployees.remove();
      }
    }

    return employees;
  }
}
