/*-
 * #%L
 * DAI Dojo - Código base Kata 3
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.kata3;

public class EmployeeNotFoundException extends Exception {
  private static final long serialVersionUID = 1L;
  private final int id;

  public EmployeeNotFoundException(int id) {
    this.id = id;
  }

  public EmployeeNotFoundException(String message, int id) {
    super(message);
    this.id = id;
  }

  public EmployeeNotFoundException(Throwable cause, int id) {
    super(cause);
    this.id = id;
  }

  public EmployeeNotFoundException(String message, Throwable cause, int id) {
    super(message, cause);
    this.id = id;
  }

  public EmployeeNotFoundException(
    String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, int id
  ) {
    super(message, cause, enableSuppression, writableStackTrace);
    this.id = id;
  }

  public int getId() {
    return this.id;
  }
}
