/*-
 * #%L
 * DAI Dojo - Código base Kata 3
 * %%
 * Copyright (C) 2014 - 2023 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.kata3.model.dao;

import java.util.List;

import es.uvigo.esei.dai.kata3.EmployeeNotFoundException;
import es.uvigo.esei.dai.kata3.model.entity.Employee;

public interface EmployeesDAO {
  public void create(Employee employee); // Debe asignársele a employee el id generado

  public void update(Employee employee) throws EmployeeNotFoundException;

  public void delete(int id) throws EmployeeNotFoundException;

  public Employee get(int id) throws EmployeeNotFoundException;

  public List<Employee> list();

  public List<Employee> listByName(String name);

  public List<Employee> listBySurname(String surname);

  public List<Employee> listBySalary(int minimumSalary);
}
