/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import nl.jqno.equalsverifier.internal.exceptions.RecursionException;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.Cache;
import nl.jqno.equalsverifier.internal.prefabvalues.FactoryCache;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.FallbackFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.SimpleFactory;

public class PrefabValues {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_OBJECT_MAPPER = PrefabValues.createPrimitiveObjectMapper();
    private final Cache cache = new Cache();
    private final FactoryCache factoryCache = new FactoryCache();
    private final PrefabValueFactory<?> fallbackFactory = new FallbackFactory();

    public <T> void addFactory(Class<T> type, PrefabValueFactory<T> factory) {
        this.factoryCache.put(type, factory);
    }

    public <T> void addFactory(Class<T> type, T red, T black, T redCopy) {
        this.factoryCache.put(type, new SimpleFactory<T>(red, black, redCopy));
    }

    public <T> T giveRed(TypeTag tag) {
        return this.giveTuple(tag).getRed();
    }

    public <T> T giveBlack(TypeTag tag) {
        return this.giveTuple(tag).getBlack();
    }

    public <T> T giveRedCopy(TypeTag tag) {
        return this.giveTuple(tag).getRedCopy();
    }

    public <T> Tuple<T> giveTuple(TypeTag tag) {
        this.realizeCacheFor(tag, this.emptyStack());
        return this.cache.getTuple(tag);
    }

    public <T> T giveOther(TypeTag tag, T value) {
        Class type = tag.getType();
        if (value != null && !type.isAssignableFrom(value.getClass()) && !this.wraps(type, value.getClass())) {
            throw new ReflectionException("TypeTag does not match value.");
        }
        Tuple<T> tuple = this.giveTuple(tag);
        if (type.isArray() && this.arraysAreDeeplyEqual(tuple.getRed(), value)) {
            return tuple.getBlack();
        }
        if (!type.isArray() && tuple.getRed().equals(value)) {
            return tuple.getBlack();
        }
        return tuple.getRed();
    }

    private boolean wraps(Class<?> expectedClass, Class<?> actualClass) {
        return PRIMITIVE_OBJECT_MAPPER.get(expectedClass) == actualClass;
    }

    private boolean arraysAreDeeplyEqual(Object x, Object y) {
        return Arrays.deepEquals(new Object[]{x}, new Object[]{y});
    }

    private LinkedHashSet<TypeTag> emptyStack() {
        return new LinkedHashSet<TypeTag>();
    }

    public <T> void realizeCacheFor(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        if (!this.cache.contains(tag)) {
            Tuple<T> tuple = this.createTuple(tag, typeStack);
            this.addToCache(tag, tuple);
        }
    }

    private <T> Tuple<T> createTuple(TypeTag tag, LinkedHashSet<TypeTag> typeStack) {
        if (typeStack.contains(tag)) {
            throw new RecursionException(typeStack);
        }
        Class type = tag.getType();
        if (this.factoryCache.contains(type)) {
            PrefabValueFactory factory = this.factoryCache.get(type);
            return factory.createValues(tag, this, typeStack);
        }
        Tuple<?> result = this.fallbackFactory.createValues(tag, this, typeStack);
        return result;
    }

    private void addToCache(TypeTag tag, Tuple<?> tuple) {
        this.cache.put(tag, tuple.getRed(), tuple.getBlack(), tuple.getRedCopy());
    }

    private static Map<Class<?>, Class<?>> createPrimitiveObjectMapper() {
        HashMap result = new HashMap();
        result.put(Boolean.TYPE, Boolean.class);
        result.put(Byte.TYPE, Byte.class);
        result.put(Character.TYPE, Character.class);
        result.put(Double.TYPE, Double.class);
        result.put(Float.TYPE, Float.class);
        result.put(Integer.TYPE, Integer.class);
        result.put(Long.TYPE, Long.class);
        result.put(Short.TYPE, Short.class);
        return result;
    }
}

