package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

public class Pet {

	private int id;
	private int owner;
	private String name;
	private String type;

	public Pet() {
	}

	public Pet(int id, String name, int owner, String type) {
		this.id = id;
		this.setName(name);
		this.setOwner(owner);
		this.setType(type);
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}

	public int getOwner() {
		return owner;
	}

	public void setOwner(int owner) {
		this.owner = requireNonNull(owner, "Owner can't be null");
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = requireNonNull(type, "Type can't be null");
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}

}
