package es.uvigo.esei.daa.controller;

import java.util.logging.Level;
import java.util.logging.Logger;

import es.uvigo.esei.daa.dao.DAOException;
import es.uvigo.esei.daa.dao.UsersDAO;
import es.uvigo.esei.daa.entities.User;

public class UsersController {
	private final static Logger LOG = Logger.getLogger(UsersController.class.getName());

	private UsersDAO dao;

	public UsersController() {
		this.dao = new UsersDAO();
	}

	public User get(String login) {
		try {
			return this.dao.get(login);

		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid user login in get method", iae);
			throw new IllegalArgumentException(iae);

		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error getting an user", e);
			throw new RuntimeException(e);
		}
	}

	public boolean checkLogin(String login, String password) {
		try {
			return this.dao.checkLogin(login, password);
		} catch (DAOException e) {
			throw new RuntimeException(e);
		}
	}
}
