package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.junit.Test;

@SuppressWarnings("unused")
public class PetUnitTest {

	@Test
	public void testPetIntStringString() {
		final int id = 1;
		final String name = "Camilo";
		final int owner = 2;
		final String type = "Perro";

		final Pet pet = new Pet(id, name, owner, type);

		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getType(), is(equalTo(type)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetNullName() {
		new Pet(1, null, 2, "Perro");
	}

	@Test(expected = NullPointerException.class)
	public void testPetNullType() {
		new Pet(1, "Camilo", 2, null);
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Camilo", 2, "Perro");

		pet.setName(null);
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullType() {
		final Pet pet = new Pet(1, "Camilo", 2, "Perro");

		pet.setType(null);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int owner = 2;

		final Pet pet = new Pet(id, "Bobi", owner, "Perro");
		pet.setName("Camilo");

		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Camilo")));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getType(), is(equalTo("Perro")));
	}

	@Test
	public void testSetType() {
		final int id = 1;
		final int owner = 2;
		final String name = "Camilo";

		final Pet pet = new Pet(id, name, owner, "Perro");
		pet.setType("Gato");

		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getType(), is(equalTo("Gato")));
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", 2,"Perro");
		final Pet petB = new Pet(1, "Name B", 3,"Gato");

		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class).withIgnoredFields("name", "owner").suppress(Warning.STRICT_INHERITANCE)
				.suppress(Warning.NONFINAL_FIELDS).verify();
	}

}
