package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetDataset {
	private PetDataset() {
	}

	public static Pet[] pet() {
		return new Pet[] { 
				new Pet(1, "Bobby", 1, "Perro"), 
				new Pet(2, "Cookie", 1, "gato"),
				new Pet(3, "Poseidon", 3, "Perro"), 
				new Pet(4, "Athenea", 3, "Gallina"),
				new Pet(5, "Kokoro", 4, "Perro"), 
				new Pet(6, "Hacendado", 4, "Lagarto") 
				
		};
	}

	public static Pet[] petWithout(int... ids) {
		Arrays.sort(ids);

		final Predicate<Pet> hasValidId = Pet -> binarySearch(ids, Pet.getId()) < 0;

		return stream(pet()).filter(hasValidId).toArray(Pet[]::new);
	}

	public static Pet Pet(int id) {
		return stream(pet()).filter(Pet -> Pet.getId() == id).findAny().orElseThrow(IllegalArgumentException::new);
	}

	public static int existentId() {
		return 3;
	}

	public static int nonExistentId() {
		return 1234;
	}

	public static int existentOwner() {
		return 1;
	}

	public static int nonExistentOwner() {
		return 4321;
	}

	public static Pet existentPet() {
		return Pet(existentId());
	}

	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Zalana", nonExistentOwner(), "Dragon");
	}

	public static String newName() {
		return "Zeus";
	}

	public static String newType() {
		return "Perro";
	}

	public static int newOwner() {
		return 3;
	}

	public static Pet newPet() {
		return new Pet(pet().length + 1, newName(), newOwner(), newType());
	}
}
