var React = require('react');
var PropTypes = require('prop-types');
var EditFormPet = require('./EditFormPet');
var queryString = require('query-string');

class Pet extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            owner:'',
            pet: null,
            pets: this.props.pets,
            editFormPet: false
        }

        this.handleEdit = this.handleEdit.bind(this);
        this.handleDelete = this.handleDelete.bind(this);
        this.updatePet = this.updatePet.bind(this);
        this.handleSubmitPet = this.handleSubmitPet.bind(this);
    }

    componentDidMount() { 
        var query = queryString.parse(this.props.location.search);
        this.updatePet(query.user,this.state.pet,this.state.pets);
    }

    updatePet(owner,pet,pets) {
        this.setState(function () {
            return {
                owner: owner,
                pet: pet,
                pets: pets,
                editFormPet: false
            }
        })
    }

    handleEdit(pet) {
        this.setState(function () {
            return { pet: pet, editFormPet: true }
        })
    }

    handleSubmitPet(pet) {
        var userIndex = this.state.pets.findIndex(obj => obj.id == pet.id);
        var newPets = this.state.pets;
        newPets[userIndex] = pet;

        this.setState(function () {
            return { pets: newPets, editFormPet: false}
        })
        
    }

    handleDelete(pet) {
        var newPets = this.state.pets.filter(function (pets) {
            return pets.name !== pet.name
        });

        if(confirm('Delete the item?')) {
        // --- Remember: setState is fucking asynchronous 
            this.setState({ pets: newPets }, function () {
            console.log("item deleted");
            });
        }
    }


    render() {
        var editFormPet = this.state.editFormPet;
        var pet = this.state.pet;
        var owner = this.state.owner;

        return (
            <div>
                <h5 className="header-owner">{owner}</h5>
                <table className="table">
                    <thead>
                        <tr className="row" >
                            {this.props.headers.map(function (head) {
                                return (
                                    <th className="col-sm-4" key={head}> {head} </th>
                                )
                            })}
                        </tr>
                    </thead>
                    <tbody>
                            {this.state.pets.map(function (pet) {
                                return(
                                    <tr className="row" key={pet.id}>
                                        <td className="col-sm-4">{pet.name}</td>
                                        <td className="col-sm-5">{pet.type}</td>
                                        <td className="col-sm-3"> 

                                            <a onClick={this.handleEdit.bind(null,pet)}
                                            className="edit btn btn-warning" 
                                            >Editar</a>

                                            <a onClick={this.handleDelete.bind(null,pet)} 
                                            className="edit btn btn-danger"
                                            >Eliminar</a>
                                        </td>
                                    </tr>
                                )
                            },this)}
                    </tbody>
                </table>
                {editFormPet &&
                    <EditFormPet pet={pet} onSubmit={this.handleSubmitPet}/>
                }
            </div> 
        )
    }  
}

Pet.propTypes = {
    headers: PropTypes.array.isRequired,
    pets: PropTypes.array.isRequired,
}

Pet.defaultProps = {
    headers: ['Nombre', 'Tipo', ' '],
    pets: [{"id":1,"owner":1,"name":"Bobby","type":"Perro"},{"id":2,"owner":1,"name":"Cookie","type":"Gato"}]
}

module.exports = Pet;