var React = require('react');
var PropTypes = require('prop-types');

class EditForm  extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            id: this.props.pet.id,
            owner: this.props.pet.owner,
            name: '',
            type:''
        }

        this.handleName = this.handleName.bind(this);
        this.handleType = this.handleType.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleName(event) {
        var value = event.target.value;

        this.setState (function () {
            return {
                name: value
            }
        });
    }

    handleType(event) {
        var value = event.target.value;

        this.setState (function () {
            return {
                type: value
            }
        });
    }

    handleSubmit (event) {
        event.preventDefault();

        var editedPet = {};
        editedPet['id'] = this.state.id;
        editedPet['owner'] = this.state.owner;
        editedPet['name'] = this.state.name;
        editedPet['type'] = this.state.type;

        this.props.onSubmit(editedPet);
        /*
        api.checkUser(this.state.username, this.state.password)
        .then(function(status){
            this.props.onSubmit (status);
        }.bind(this));
        */
    }
    render() { 
        return ( 
        <div>
            <form className='login' onSubmit={this.handleSubmit}>
                    <input
                        id='name'
                        placeholder= {this.props.pet.name}
                        type='text'
                        value={this.state.name}
                        autoComplete='off'
                        onChange = {this.handleName}
                    />

                    <input
                        id='surname'
                        placeholder={this.props.pet.type}
                        type='text'
                        value={this.state.type}
                        autoComplete='off'
                        onChange = {this.handleType}
                    />

                    <button className='button' type='submit'>
                        Submit
                    </button>
            </form>
        </div>

        )
    }
}

EditForm.propTypes = {
    pet: PropTypes.object.isRequired
}
 
module.exports = EditForm;