var React = require('react');
var PropTypes = require('prop-types');
var EditFormPerson = require('./EditFormPerson');
var Link = require('react-router-dom').Link;
class Person extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            user: null,
            pets: this.props.pets,
            people: this.props.people,
            editFormPerson: false,
        }

        this.handleEdit = this.handleEdit.bind(this);
        this.handleDelete = this.handleDelete.bind(this);
        this.updatePeople = this.updatePeople.bind(this);
        this.handleSubmitPerson = this.handleSubmitPerson.bind(this);
    }
    

    componentDidMount() {
        this.updatePeople(this.state.user,this.state.pets,this.state.people);
    }

    updatePeople(user,pets,people) {
        this.setState(function () {
            return {
                user: user,
                pets: pets,
                people: people,
                editFormPerson: false,
            }
        })
    }

    handleEdit(user) {        
        this.setState(function () {
            return { user: user, editFormPerson: true }
        })
    }

    handleSubmitPerson(user) {
        var userIndex = this.state.people.findIndex(obj => obj.id == user.id);
        var newPeople = this.state.people;
        newPeople[userIndex] = user;

        this.setState(function () {
            return { people: newPeople, editFormPerson: false}
        })
        
    }

    handleDelete(user) {
        var newPeople = this.state.people.filter(function (person) {
            return person.name !== user.name
        });

        // --- Remember: setState is fucking asynchronous 
        if(confirm('Delete the item?')) {
            this.setState({people: newPeople}, function () {

            });
        }
    }

    render() { 
        var editFormPerson = this.state.editFormPerson;
        var person = this.state.user;
        var match = this.props.match;

        return (
            <div>
                <table className="table">
                    <thead>
                        <tr className="row" >
                            {this.props.headers.map(function (head) {
                                return (
                                    <th className="col-sm-4" key={head}> {head} </th>
                                )
                            })}
                        </tr>
                    </thead>
                    <tbody>
                            {this.state.people.map(function (user) {
                                return(  
                                    <tr className="row" key={user.id}>
                                        <td className="col-sm-4">{user.name}</td>
                                        <td className="col-sm-5">{user.surname}</td>
                                        <td className="col-sm-3"> 

                                            <a onClick={this.handleEdit.bind(null,user)}
                                            className="edit btn btn-warning" 
                                            >Editar</a>

                                            <a onClick={this.handleDelete.bind(null,user)} 
                                            className="edit btn btn-danger"
                                            >Eliminar</a>
                                            
                                            <Link
                                            className="edit btn btn-info" 
                                            to={{
                                                pathname: match.url + '/pet',
                                                search:'?user='+user.name
                                            }}
                                            >Pets</Link>
                                        </td>
                                    </tr>
                                )
                            },this)}
                    </tbody>
                </table>
                {editFormPerson &&
                    <EditFormPerson person={person} onSubmit={this.handleSubmitPerson}/>
                }
            </div>
        )
    }  
}

Person.propTypes = {
    headers: PropTypes.array.isRequired,
    people: PropTypes.array.isRequired,
    pets: PropTypes.array.isRequired,
}

Person.defaultProps = {
    headers: ['Nombre', 'Apellido', ' '],
    people:  [{"id":0,"name":"Antón","surname":"Pérez"},{"id":1,"name":"Manuel","surname":"Martínez"}],
    pets: [{"id":1,"owner":1,"name":"Bobby","type":"Perro"},{"id":2,"owner":1,"name":"Cookie","type":"Gato"}]
}

module.exports = Person;