var React = require('react');
var PropTypes = require('prop-types');

class EditFormPerson  extends React.Component {
    constructor(props) {
        super(props);
        this.state = { 
            id: this.props.person.id,
            name: '',
            surname:''
        }

        this.handleName = this.handleName.bind(this);
        this.handleSurname = this.handleSurname.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleName(event) {
        var value = event.target.value;

        this.setState (function () {
            return {
                name: value
            }
        });
    }

    handleSurname(event) {
        var value = event.target.value;

        this.setState (function () {
            return {
                surname: value
            }
        });
    }

    handleSubmit (event) {
        event.preventDefault();
        
        var editedUser = {};
        editedUser['id'] = this.state.id;
        editedUser['name'] = this.state.name;
        editedUser['surname'] = this.state.surname;

        this.props.onSubmit(editedUser);

        /*
        api.checkUser(this.state.username, this.state.password)
        .then(function(status){
            this.props.onSubmit (status);
        }.bind(this));
        */
    }
    render() { 
        return ( 
        <div>
            <form className='login' onSubmit={this.handleSubmit}>
                    <input
                        id='name'
                        placeholder= {this.props.person.name}
                        type='text'
                        value={this.state.name}
                        autoComplete='off'
                        onChange = {this.handleName}
                    />

                    <input
                        id='surname'
                        placeholder={this.props.person.surname}
                        type='text'
                        value={this.state.surname}
                        autoComplete='off'
                        onChange = {this.handleSurname}
                    />

                    <button className='button' type='submit'>
                        Submit
                    </button>
            </form>
        </div>

        )
    }
}

EditFormPerson.propTypes = {
    person: PropTypes.object.isRequired
}
 
module.exports = EditFormPerson;