var React = require('react');
var PropTypes = require('prop-types');
var Person = require('../components/entity/person/Person');
var queryString = require('query-string');

class Content extends React.Component {
    constructor(props) {
        super(props);
        this.state = 
        {
            userLogged: this.props.user

        }

    }
    componentDidMount(){
        var query = queryString.parse(this.props.location.search);
        console.log(query);
        this.updateContent(query.login);
    }

    updateContent(userLogged) {
        this.setState(function () {
            return {
                userLogged:userLogged
            }
        })
    }
    render() { 
        //Router url
        var match = this.props.match;
        var userLogged = this.state.userLogged;
        return (
            <div className="container">
                {userLogged &&
                    <div>
                        <p className="header-owner">Personas</p>
                        <Person match={match}/>
                    </div>
                }
            </div>
        )
    }
}

module.exports = Content;
