import React, { Component } from 'react';
import PropTypes from 'prop-types';

export default class Pet extends Component {
    constructor(props) {
        super(props);
    }
    render() {
        return (
            <div>
                <h5 className="header-owner">Owner</h5>
                <table className="table">
                    <thead>
                        <tr className="row" >
                            {this.props.headers.map(function (head) {
                                return (
                                    <th className="col-sm-4" key={head}> {head} </th>
                                )
                            })}
                        </tr>
                    </thead>
                    <tbody>
                        {this.props.pets.map(function (pet) {
                            return (
                                <tr className="row" key={pet.id}>
                                    <td className="col-sm-4">{pet.name}</td>
                                    <td className="col-sm-5">{pet.type}</td>
                                    <td className="col-sm-3">
                                        <a className="edit btn btn-warning" >Editar</a>
                                        <a className="edit btn btn-danger">Eliminar</a>
                                    </td>
                                </tr>
                            )
                        }, this)}
                    </tbody>
                </table>
            </div>
        )
    }
}

Pet.propTypes = {
    headers: PropTypes.array.isRequired,
    pets: PropTypes.array.isRequired,
}

Pet.defaultProps = {
    headers: ['Nombre', 'Tipo', ' '],
    pets: [{ "id": 1, "owner": 1, "name": "Bobby", "type": "Perro" }, { "id": 2, "owner": 1, "name": "Cookie", "type": "Gato" }]
}