import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Table from './Table';

export default class People extends Component {
    constructor(props) {
        super(props);
    }

    renderPeople(user) {
        return (
            <tr className="row" key={user.id}>
                <td className="col-sm-4">{user.name}</td>
                <td className="col-sm-4">{user.surname}</td>
                <td className="col-sm-4">
                    <a className="edit btn btn-warning" >Editar</a>
                    <a className="edit btn btn-danger">Eliminar</a>
                </td>
            </tr>
        );
    }
    render() {
        return (
            <Table data={this.props.people} headers={this.props.headers} />

        )
    }
}

People.propTypes = {
    headers: PropTypes.array.isRequired,
    people: PropTypes.array.isRequired,
    pets: PropTypes.array.isRequired,
}

People.defaultProps = {
    headers: ['Nombre', 'Apellido', ' '],
    people: [{ "id": 0, "name": "Antón", "surname": "Pérez" }, { "id": 1, "name": "Manuel", "surname": "Martínez" }],
    pets: [{ "id": 1, "owner": 1, "name": "Bobby", "type": "Perro" }, { "id": 2, "owner": 1, "name": "Cookie", "type": "Gato" }]
}