var React = require('react');
var Link = require('react-router-dom').Link;
var Redirect = require('react-router-dom').Redirect;
var api = require('../utils/Api');
var PropTypes = require('prop-types');

class Login extends React.Component {
    constructor(props) {
        super(props);

        this.state = {
            username:'',
            password:'',
        }

        this.handleUsername = this.handleUsername.bind(this);
        this.handlePassword = this.handlePassword.bind(this);
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleUsername(event) {
        var value = event.target.value;

        this.setState (function () {
            return {
                username: value
            }
        });
    }

    handlePassword(event) {
        var value = event.target.value;

        this.setState (function () {
            return {
                password: value
            }
        });
    }

    handleSubmit (event) {
        event.preventDefault();
        
        api.checkUser(this.state.username, this.state.password)
        .then(function(status){
            this.props.onSubmit (status);
        }.bind(this));
    }

    render() { 
        return (
           <form className='login' onSubmit={this.handleSubmit}>
                <input
                    id='username'
                    placeholder='username'
                    type='text'
                    value={this.state.username}
                    autoComplete='off'
                    onChange = {this.handleUsername}
                />

                <input
                    id='password'
                    placeholder='password'
                    type='password'
                    value={this.state.password}
                    autoComplete='off'
                    onChange = {this.handlePassword}
                />

                <button className='button' type='submit'>
                    Submit
                </button>
           </form>
        )
    }
}

Login.propTypes = {
    onSubmit: PropTypes.func.isRequired
}
class Main extends React.Component {
    constructor(props) {
        super(props);
        
        this.state = {
            user: false,
        }

        this.handleSubmit = this.handleSubmit.bind(this);
    }



    handleSubmit(isValid) {
        this.setState(function () {
            return {
                user: isValid
            }
        })
    }

    render() { 
        var validUser = this.state.user;
        var message = this.state.message;
        var match = this.props.match;

            return (
                <div> 
                    <h4 className="header">{message}</h4>

                    {!validUser &&
                        <Login onSubmit={this.handleSubmit}/>
                    }

                    {validUser &&
                        <Redirect
                        to={{
                            pathname:match.url+'people',
                            search:'?login='+validUser
                        }}
                        />
                    }
                </div>
            
            )
    }
}
 
module.exports = Main;