package es.uvigo.esei.xcs.service;

import javax.annotation.PostConstruct;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

/**
 * Singleton EJB that maintains counters for pets and vaccines.
 * 
 * Counts are initialized from the database and kept in memory.
 * Thread-safe access is ensured through read/write locks.
 * 
 * @author Breixo
 */
@Singleton
public class CounterService {
	
	@PersistenceContext
	private EntityManager em;
	
	private Long vaccineCounter;
	private Long petCounter;

	/**
	 * Initializes counters with the current counts from the database.
	 */
	@PostConstruct
	public void init() {
		this.petCounter = em.createQuery("SELECT COUNT(p) FROM Pet p", Long.class)
		                    .getSingleResult();
		
		this.vaccineCounter = em.createQuery("SELECT COUNT(v) FROM Vaccine v", Long.class)
		                        .getSingleResult();
	}

	/**
	 * Increments the pet counter by one.
	 */
	@Lock(LockType.WRITE)
	public void incrementPetCounter() {
		this.petCounter++;
	}

	/**
	 * Increments the vaccine counter by one.
	 */
	@Lock(LockType.WRITE)
	public void incrementVaccineCounter() {
		this.vaccineCounter++;
	}

	/**
	 * Returns the current pet counter value.
	 */
	@Lock(LockType.READ)
	public Long getPetCounter() {
		return this.petCounter;
	}

	/**
	 * Returns the current vaccine counter value.
	 */
	@Lock(LockType.READ)
	public Long getVaccineCounter() {
		return this.vaccineCounter;
	}
}
