/*package es.uvigo.esei.xcs.domain.entities;

import static java.util.Arrays.copyOfRange;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.MatcherAssert.assertThat;

import java.util.Date;

import org.junit.Before;
import org.junit.Test;

public class OwnerTest extends UserTest {
    private Pet[] pets;
    private Pet petOwned;
    private Pet petNotOwned;
    private Pet[] petsWithoutOwned;
    private Owner owner;

    @Before
    public void setUpOwner() throws Exception {
        this.owner = new Owner("juan", "123456");

        this.pets = new Pet[] {
            new Pet("Lassie", AnimalType.DOG, new Date(), owner),
            new Pet("Pajaroto", AnimalType.BIRD, new Date(), owner)
        };
        this.petOwned = this.pets[1];
        this.petNotOwned = new Pet("Doraemon", AnimalType.CAT, new Date(), new Owner("otro", "000000"));
        this.petsWithoutOwned = copyOfRange(this.pets, 0, 1);
    }

    @Override
    protected User newUser(String login, String password) {
        return new Owner(login, password);
    }

    @Test
    public void testAddPetAndOwnerLink() {
        final Owner newOwner = new Owner("ana", "password");
        final Pet pet = new Pet("Milo", AnimalType.DOG, new Date(), new Owner("old", "111111"));

        newOwner.addPet(pet);

        assertThat(newOwner.ownsPet(pet), is(true));
        assertThat(pet.getOwner(), is(newOwner));
    }

    @Test
    public void testRemovePetAndOwnerLink() {
        final Owner owner = new Owner("carlos", "password", pets);
        owner.removePet(petOwned);

        assertThat(owner.ownsPet(petOwned), is(false));
        assertThat(petOwned.getOwner(), is(nullValue()));
    }
}
*/
