/*package es.uvigo.esei.xcs.domain.entities;

import static org.hamcrest.CoreMatchers.*;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsEmptyCollection.empty;

import org.junit.Before;
import org.junit.Test;

public class VaccineTest {
	private Vaccine vaccine;
	private Vaccination vaccination;

	@Before
	public void setUp() {
		vaccine = new Vaccine("Rabies");
		vaccination = new Vaccination();
	}

	@Test
	public void testConstructorAndGetName() {
		assertThat(vaccine.getName(), is("Rabies"));
		assertThat(vaccine.getVaccinations(), is(empty()));
	}

	@Test
	public void testSetName() {
		vaccine.setName("Distemper");
		assertThat(vaccine.getName(), is("Distemper"));
	}

	@Test
	public void testAddVaccination() {
		vaccine.addVaccination(vaccination);
		assertThat(vaccination.getVaccine(), is(vaccine));
	}

	@Test(expected = NullPointerException.class)
	public void testAddVaccinationNull() {
		vaccine.addVaccination(null);
	}

	@Test
	public void testRemoveVaccination() {
		vaccine.addVaccination(vaccination);
		vaccine.removeVaccination(vaccination);
		assertThat(vaccination.getVaccine(), is(nullValue()));
	}

	@Test(expected = NullPointerException.class)
	public void testRemoveVaccinationNull() {
		vaccine.removeVaccination(null);
	}

	@Test
	public void testOwnsVaccination() {
		vaccine.internalAddVaccination(vaccination);
		assertThat(vaccine.ownsVaccination(vaccination), is(true));
	}

	@Test
	public void testInternalRemoveVaccination() {
		vaccine.internalAddVaccination(vaccination);
		vaccine.internalRemoveVaccination(vaccination);
		assertThat(vaccine.getVaccinations(), is(empty()));
	}
}*/
