package es.uvigo.esei.xcs.service;

import static java.util.Objects.requireNonNull;

import java.security.Principal;
import java.util.List;

import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.IdentifierType;
import es.uvigo.esei.xcs.domain.entities.Pet;
import es.uvigo.esei.xcs.domain.entities.Vaccination;
import es.uvigo.esei.xcs.domain.entities.Vet;

@Stateless
//@RolesAllowed("VET")
@PermitAll
public class VetService {
	@Inject
	private Principal currentUser;
	
	@PersistenceContext
	EntityManager em;
	
	public Vet get(String login) {
		return em.find(Vet.class, login);
	}
	
	
	public List<Vet> list(){
		return em.createQuery("SELECT DISTINCT v FROM Vet v", Vet.class)
				.getResultList();
	}


	public List<Vet> findByPetName(String petName, int page, int pageSize){
		requireNonNull(petName, "Pet's name can't be null");
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return this.em.createQuery("SELECT DISTINCT v FROM Vet v JOIN v.pets p "
				+ "WHERE p.name = :petName", Vet.class)
				.setFirstResult(page * pageSize)
				.setMaxResults(pageSize)
				.setParameter("petName", petName)
				.getResultList();
	}
	
	
	public Vet create(Vet vet) {
		requireNonNull(Vet.class, "Vet can't be null");
		em.persist(vet);
		return vet;
	}
	
	
	public Vet update(Vet vet) {
		requireNonNull(Vet.class, "Vet can't be null");
		return em.merge(vet);
	}
		
	
	public void remove(String login) {
		em.remove(this.get(login));
	}

	
	public List<Pet> getPets(int page , int pageSize) {
		//requireNonNull(login, "Login can't be null");
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return this.em.createQuery("SELECT DISTINCT p FROM Vet v JOIN v.pets p "
				+ "WHERE v.login = :login", Pet.class)
				.setFirstResult(page * pageSize)
				.setMaxResults(pageSize)
				.setParameter("login", currentUser.getName())
				.getResultList();
	}
	
	public List<Vaccination> getVaccinationsFromOwnPet(
			//String login, 
			IdentifierType identifierType,
			String identifierValue,
			int page,
			int pageSize
	){
		//requireNonNull(login, "login can't be null");
		requireNonNull(identifierType, "pet's identifier type can't be null");
		requireNonNull(identifierValue, "pet's identifier value can't be null");
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return em.createQuery(
				"SELECT v FROM Vet vet "
				+ "JOIN vet.pets p "
				+ "JOIN p.identifiers i "
				+ "JOIN p.vaccinations v "
				+ "WHERE "
				+ "vet.login = :login AND "
				+ "i.identifierType = :identifierType AND "
				+ "i.identifierValue = :identifierValue", 
				Vaccination.class)
			.setParameter("login", currentUser.getName())
			.setParameter("identifierType", identifierType)
			.setParameter("identifierValue", identifierValue)
			.setFirstResult(page * pageSize)
			.setMaxResults(pageSize)
			.getResultList();
	}
	
	public void assignPetToVet() {
		
	}
	
	
}
