package es.uvigo.esei.xcs.service;

import java.security.Principal;
import java.util.List;

import static java.util.Objects.requireNonNull;

import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.User;

@Stateless
@RolesAllowed({"OWNER", "ADMIN", "VET"})
public class UserService {
  @PersistenceContext
  private EntityManager em;
  
  @Inject
  private Principal principal;

  /**
   * Returns the current user entity.
   * 
   * @return the entity with the information of the current user.
   */
  public User getCurrentUser() {
    return this.em.find(User.class, this.principal.getName());
  }
  
  public User get(String login) {
	  return this.em.find(User.class, login);
  }
  
  public List<User> list(int page, int pageSize){
	if (page < 0) {
		throw new IllegalArgumentException("The page can't be negative");
	}
	if (pageSize <= 0) {
		throw new IllegalArgumentException("The page size can't be negative or zero");
	}
	return this.em.createQuery("SELECT DISTINCT u FROM User u", User.class)
			.setFirstResult(page * pageSize)
			.setMaxResults(pageSize)
			.getResultList();
  }
  
  public User create(User user) {
	  requireNonNull(user, "User can't be null");
	  this.em.persist(user);
	  return user;
  }
  
  public void remove(String login) {
	  User user = this.get(login);
	  this.em.remove(user);
  }
  
  
  
}
