package es.uvigo.esei.xcs.jsf;

import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.faces.context.FacesContext;
import java.util.Map;

import es.uvigo.esei.xcs.domain.entities.Pet;
import es.uvigo.esei.xcs.service.PetService;

@Named("petDetails")
@RequestScoped
public class PetDetailsManagedBean {
    @Inject
    private PetService service;

    private Pet pet;

    @PostConstruct
    public void init() {
        Map<String, String> params = FacesContext.getCurrentInstance()
                .getExternalContext()
                .getRequestParameterMap();
        String id = params.get("id");
        if (id != null) {
            this.pet = service.get(Long.parseLong(id));
        }
    }

    public Pet getPet() {
        return pet;
    }
}
