package es.uvigo.esei.xcs.service;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.Identifier;
import static java.util.Objects.requireNonNull;

@Stateless
public class IdentifierService {
	@PersistenceContext
	EntityManager em;
	
	
	public Identifier create(Identifier identifier) {
		requireNonNull(identifier, "Identifier can't be null");
		em.persist(identifier);
		return identifier;
	}
	
	public void remove(String value) {
		Identifier identifier = em.find(Identifier.class, value);
		em.remove(identifier);
	}
	
}
