package es.uvigo.esei.xcs.rest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import es.uvigo.esei.xcs.domain.entities.Vaccination;
import es.uvigo.esei.xcs.service.VaccinationService;

@Path("vaccination")
@Consumes(MediaType.APPLICATION_JSON)
@Produces(MediaType.APPLICATION_JSON)
public class VaccinationResource {

    @EJB
    private VaccinationService vaccinationService;

    @GET
    @Path("canVaccinate/{petId}/{vaccineId}")
    public Response canVaccinate(
            @PathParam("petId") Long petId,
            @PathParam("vaccineId") Long vaccineId
    ) {
        Date now = new Date();
        Boolean result = vaccinationService.canVaccinate(petId, vaccineId, now);
        return Response.ok(result).build();
    }
    
    
    @POST
    @Path("create/{petId}/{vaccineId}")
    public Response createVaccination(
            @PathParam("petId") Long petId,
            @PathParam("vaccineId") Long vaccineId,
            @QueryParam("date") String textDate  // opcional, formato yyyy-MM-dd
    ) {
        Date date = new Date();
        if (textDate != null) {
            try {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(textDate);
            } catch (ParseException e) {
                return Response.status(Response.Status.BAD_REQUEST)
                        .entity("Invalid date format, expected yyyy-MM-dd").build();
            }
        }

        try {
            Vaccination vaccination = vaccinationService.create(petId, vaccineId, date);
            return Response.ok(vaccination).build();
        } catch (IllegalArgumentException e) {
            return Response.status(Response.Status.BAD_REQUEST)
                    .entity(e.getMessage()).build();
        }
    }
    
}
