package es.uvigo.esei.xcs.service;

import java.util.Date;
import static java.util.Objects.requireNonNull;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import es.uvigo.esei.xcs.domain.entities.Pet;
import es.uvigo.esei.xcs.domain.entities.Vaccination;
import es.uvigo.esei.xcs.domain.entities.Vaccine;

@Stateless
public class VaccinationService {
	@PersistenceContext
	EntityManager em;
	
	
	public Vaccination get(int vaccinationId) {
		return em.find(Vaccination.class, vaccinationId);
	}
	
	
	public List<Vaccination> list(int page, int pageSize){
		if (page < 0) {
			throw new IllegalArgumentException("The page can't be negative");
		}
		if (pageSize <= 0) {
			throw new IllegalArgumentException("The page size can't be negative or zero");
		}
		return em.createQuery("SELECT DISTINCT v FROM Vaccination v", Vaccination.class)
				.setFirstResult(page * pageSize)
				.setMaxResults(pageSize)
				.getResultList();
	}
	
	
	public Vaccination create(int petId, int vaccineId, String textDate) {
	    Pet pet = requireNonNull(em.find(Pet.class, petId), "Pet can't be null");
	    Vaccine vaccine = requireNonNull(em.find(Vaccine.class, vaccineId), "Vaccine can't be null");
	    Date date = new Date();
	    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
	    if(textDate != null) {
	    	try {
				date = format.parse(textDate);
			} catch (ParseException e) {
				date = null;
			}
	    }
	    
	    Vaccination vaccination = new Vaccination(pet, vaccine, date);
	    em.persist(vaccination);
	    return vaccination;
	}
	
	
	public Vaccination updateDate(int vaccinationId, Date date) {
		Vaccination vaccination = em.find(Vaccination.class, vaccinationId);
		requireNonNull(vaccination, "Vaccination can't be null");
		vaccination.setDate(date);
		return em.merge(vaccination);
	}
	
	
	public void remove(int vaccinationId) {
		Vaccination vaccination = this.get(vaccinationId);
		requireNonNull(vaccination, "Vaccination can't be null");
		em.remove(vaccination);
	}
	
	
}
