/*package es.uvigo.esei.xcs.domain.entities;

import static org.hamcrest.CoreMatchers.*;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsEmptyCollection.empty;

import java.util.Date;

import org.junit.Before;
import org.junit.Test;

public class PetTest {
    private Pet pet;
    private Owner owner;
    private Vet vet;
    private Vaccination vaccination;

    @Before
    public void setUp() {
        owner = new Owner("Pepe", "pepepa");
        vet = new Vet("DrVet", "vetpass");
        vaccination = new Vaccination(new Date(), null, null);
        pet = new Pet("Lassie", AnimalType.DOG, new Date(), owner);
    }

    @Test
    public void testConstructorAndGetters() {
        assertThat(pet.getName(), is("Lassie"));
        assertThat(pet.getAnimal(), is(AnimalType.DOG));
        assertThat(pet.getOwner(), is(owner));
        assertThat(pet.getVets(), is(empty()));
        assertThat(pet.getVaccinations(), is(empty()));
    }

    @Test
    public void testSetNameAnimalBirth() {
        Date birth = new Date();
        pet.setName("Rex");
        pet.setAnimal(AnimalType.CAT);
        pet.setBirth(birth);

        assertThat(pet.getName(), is("Rex"));
        assertThat(pet.getAnimal(), is(AnimalType.CAT));
        assertThat(pet.getBirth(), is(birth));
    }

    @Test(expected = NullPointerException.class)
    public void testSetNameNull() { pet.setName(null); }

    @Test(expected = NullPointerException.class)
    public void testSetAnimalNull() { pet.setAnimal(null); }

    @Test(expected = NullPointerException.class)
    public void testSetBirthNull() { pet.setBirth(null); }

    @Test
    public void testAddAndRemoveVet() {
        pet.addVet(vet);
        pet.internalAddVet(vet);
        assertThat(pet.ownsVet(vet), is(true));
        assertThat(vet.ownsPet(pet), is(true));

        pet.removeVet(vet);
        pet.internalRemoveVet(vet);
        assertThat(pet.ownsVet(vet), is(false));
        assertThat(vet.ownsPet(pet), is(false));
    }

    @Test
    public void testAddAndRemoveVaccination() {
        pet.addVaccination(vaccination);
        pet.internalAddVaccination(vaccination);
        assertThat(pet.ownsVaccination(vaccination), is(true));
        assertThat(vaccination.getPet(), is(pet));

        pet.removeVaccination(vaccination);
        pet.internalRemoveVaccination(vaccination);
        assertThat(pet.ownsVaccination(vaccination), is(false));
        assertThat(vaccination.getPet(), is(nullValue()));
    }
}
*/
