package es.uvigo.esei.xcs.domain.entities;


import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity(name="Identifier")
@XmlRootElement(name = "identifier", namespace = "http://entities.domain.xcs.esei.uvigo.es")
public class Identifier {
	@Id
	@Column(length = 32, nullable = false)
	private String value;
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JsonIgnore
	private Pet pet;
	
	
	@Enumerated(EnumType.STRING)
	@Column(length = 4, nullable = false)
	private IdentifierType type;

	public Identifier() {
	}
	
	Identifier(Pet pet, String value, IdentifierType type) {
		this.pet = pet;
		this.value = value;
		this.type = type;
	}

	
	public Pet getPet() {
		return this.pet;
	}
	
	public void setPet(Pet pet) {
		if (this.pet != null) {
			this.pet.internalRemoveIdentifier(this);
		}
		this.pet = pet;
		if (pet != null) {
			pet.internalAddIdentifier(this);
		}
	}
	
	public String getValue() {
		return this.value;
	}
	
	public IdentifierType getType() {
		return this.type;
	}
	
}
