package es.uvigo.esei.xcs.domain.entities;

import static java.util.Objects.requireNonNull;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;

import com.fasterxml.jackson.annotation.JsonIgnore;

@Entity
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name = "VACCINE_TYPE")
public class Vaccine implements Serializable {
	private static final long serialVersionUID = 1L;

	public Vaccine() {}
	
	public Vaccine(String name) {
		this.name = name;
		this.vaccinations = new HashSet<Vaccination>();
	}
	
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY) //AUTO no genera auto_increment en MySQL
	private Long id;
	
	@Column(name = "name", nullable = false, length = 128)
	protected String name;
	
	@OneToMany(
		mappedBy = "vaccine",
		cascade = CascadeType.ALL,
		orphanRemoval = true,
		fetch = FetchType.EAGER
	)
	@JsonIgnore
	private Set<Vaccination> vaccinations;
	
	public Long getId() {
		return id;
	}
	
	public String getName() {
		return this.name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	
	public Boolean ownsVaccination(Vaccination vaccination) {
		return this.vaccinations.contains(vaccination);
	}
	
	public Collection<Vaccination> getVaccinations() {
		return this.vaccinations;
	}
	
	public void addVaccination(Vaccination vaccination) {
		requireNonNull(vaccination, "Vaccination can't be null");
		vaccination.setVaccine(this);
	}
	
	void internalAddVaccination(Vaccination vaccination) {
		requireNonNull(vaccination, "Vaccination can't be null");
		
		if (!ownsVaccination(vaccination)) {
			this.vaccinations.add(vaccination);
		}
	}
	
	public void removeVaccination(Vaccination vaccination) {
		requireNonNull(vaccination, "Vaccination can't be null");
		vaccination.setVaccine(null);
	}
	
	void internalRemoveVaccination(Vaccination vaccination) {
		this.vaccinations.remove(vaccination);
	}
	

}
