package es.uvigo.esei.xcs.jsf;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import es.uvigo.esei.xcs.domain.entities.Vaccine;
import es.uvigo.esei.xcs.service.VaccineService;

@Named("vaccine")
@RequestScoped
public class VaccineManagedBean{

	@EJB
    private VaccineService vaccineService;

    private List<Vaccine> vaccines;
    private String name;
    private String type;
    private Integer doses;
    private Integer periode;
    private String periodicType;

    @PostConstruct
    public void init() {
        vaccines = vaccineService.list(0, 100);
    }

    public void createVaccine() {
        vaccineService.create(name, type, doses, periodicType, periode);
        vaccines = vaccineService.list(0, 100);
        clearForm();
    }

    public void removeVaccine(Long id) {
        vaccineService.remove(id);
        vaccines = vaccineService.list(0, 100);
    }
    

    private void clearForm() {
        name = null;
        type = null;
        doses = null;
        periode = null;
        periodicType = null;
    }

    // Getters y setters
    public List<Vaccine> getVaccines() { return vaccines; }
    public String getName() { return name; }
    public void setName(String name) { this.name = name; }
    public String getType() { return type; }
    public void setType(String type) { this.type = type; }
    public Integer getDoses() { return doses; }
    public void setDoses(Integer doses) { this.doses = doses; }
    public Integer getPeriode() { return periode; }
    public void setPeriode(Integer periode) { this.periode = periode; }
    public String getPeriodicType() { return periodicType; }
    public void setPeriodicType(String periodicType) { this.periodicType = periodicType; }
}
