package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetsDataset {
	private PetsDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Tofe", 2),
			new Pet(2, "Niki", 3),
			new Pet(3, "Tobi", 1),
			new Pet(4, "Tara", 2),
			new Pet(5, "Tim", 5),
			new Pet(6, "Trosky", 6),
		};
	}
	
	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static Integer existentId() {
		return 5;
	}
	
	public static Integer nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Baddy", 4);
	}
	
	public static String newPetName() {
		return "Miku";
	}
	
	public static Integer newOwnerId() {
		return 4;
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newPetName(), newOwnerId());
	}
}