package es.uvigo.esei.daa.dao;
import java.sql.Connection;
import es.uvigo.esei.daa.dao.PeopleDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import es.uvigo.esei.daa.entities.Person;
import es.uvigo.esei.daa.entities.Pet;

public class PetsDAO extends DAO{
	private final static java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(PetsDAO.class.getName());
	PeopleDAO pdao = new PeopleDAO();
	
	
	//retorna una mascota a partir de un id
	public Pet get(int id)
	throws DAOException, IllegalArgumentException {
		try (final Connection conn = this.getConnection()) {
			final String query = "SELECT * FROM pets WHERE id=?";
			
			try (final PreparedStatement statement = conn.prepareStatement(query)) {
				statement.setInt(1, id);
				
				try (final ResultSet result = statement.executeQuery()) {
					if (result.next()) {
						return rowToEntity(result);
					} else {
						throw new IllegalArgumentException("Invalid id");
					}
				}
			}
		} catch (SQLException e) {
			LOG.log(Level.SEVERE, "Error getting a pet", e);
			throw new DAOException(e);
		}
	}
	
	//devuelve una lista con todas las mascotas registradas
	public List<Pet> list() throws DAOException {
		try (final Connection conn = this.getConnection()) {
			final String query = "SELECT * FROM pets";
			
			try (final PreparedStatement statement = conn.prepareStatement(query)) {
				try (final ResultSet result = statement.executeQuery()) {
					final List<Pet> pets = new LinkedList<>();
					
					while (result.next()) {
						pets.add(rowToEntity(result));
					}
					
					return pets;
				}
			}
		} catch (SQLException e) {
			LOG.log(Level.SEVERE, "Error listing pets", e);
			throw new DAOException(e);
		}
	} 
	
	//registra una mascota
	public Pet add(String pet_name, int owner_id)
			throws DAOException, IllegalArgumentException {
				boolean esPersona = false;
				PeopleDAO peopleDao = new PeopleDAO();
				List<Person> listaPeople = peopleDao.list();
				for(Person p : listaPeople) {
					//LOG.log(Level.INFO, ""+p.getId()+" "+owner_id);
					if(p.getId() == owner_id || owner_id == 0) {
						esPersona = true;
					}
				}
				if(!esPersona) {
					throw new IllegalArgumentException("owner_id doesn´t exist");
				}
				if (pet_name == null || owner_id < 0) {
					throw new IllegalArgumentException("pet name and owner_id can't be null");
				}
				
				try (Connection conn = this.getConnection()) {
					LOG.log(Level.INFO, "ID: "+owner_id);
					final String query = "INSERT INTO pets VALUES(null, ?, ?)";
					try (PreparedStatement statement = conn.prepareStatement(query, Statement.RETURN_GENERATED_KEYS)) {
						statement.setString(1, pet_name);
						statement.setInt(2, owner_id);
						if (statement.executeUpdate() == 1) {
							try (ResultSet resultKeys = statement.getGeneratedKeys()) {
								if (resultKeys.next()) {
									Pet p = new Pet(resultKeys.getInt(1), pet_name, owner_id);
									//LOG.log(Level.INFO, p.toString());
									return p;
								} else {
									LOG.log(Level.SEVERE, "Error retrieving inserted id");
									throw new SQLException("Error retrieving inserted id");
								}
							}
						} else {
							LOG.log(Level.SEVERE, "Error inserting value");
							throw new SQLException("Error inserting value");
						}
					}
				} catch (SQLException e) {
					LOG.log(Level.SEVERE, "Error adding a pet", e);
					throw new DAOException(e);
				}
			}
	
	//modifica los datos de una persona
	public void modify(Pet pet)
			throws DAOException, IllegalArgumentException {
				if (pet == null) {
					throw new IllegalArgumentException("pet can't be null");
				}
				
				try (Connection conn = this.getConnection()) {
					final String query = "UPDATE pets SET pet_name=?, owner_id=? WHERE id=?";
					
					try (PreparedStatement statement = conn.prepareStatement(query)) {
						statement.setString(1, pet.getpet_name());
						statement.setInt(2, pet.getowner_id());
						statement.setInt(3, pet.getId());
						
						if (statement.executeUpdate() != 1) {
							throw new IllegalArgumentException("name and owner can't be null");
						}
					}
				} catch (SQLException e) {
					LOG.log(Level.SEVERE, "Error modifying a pet", e);
					throw new DAOException();
				}
			}
	
	//elimina una mascota a partir de su id
	public void delete(int id)
			throws DAOException, IllegalArgumentException {
				try (final Connection conn = this.getConnection()) {
					final String query = "DELETE FROM pets WHERE id=?";
					
					try (final PreparedStatement statement = conn.prepareStatement(query)) {
						statement.setInt(1, id);
						
						if (statement.executeUpdate() != 1) {
							throw new IllegalArgumentException("Invalid id");
						}
					}
				} catch (SQLException e) {
					LOG.log(Level.SEVERE, "Error deleting a pet", e);
					throw new DAOException(e);
				}
			}
			
			private Pet rowToEntity(ResultSet row) throws SQLException {
				return new Pet(
					row.getInt("id"),
					row.getString("pet_name"),
					row.getInt("owner_id")
				);
			}
			
	
}
