package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetsUnitTest {
	@Test
	public void testPetIntStringInt() {
		final int id = 1;
		final String name = "Laia";
		final int ownerId = 4;
		
		final Pet pet = new Pet(id, name, ownerId);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getpet_name(), is(equalTo(name)));
		assertThat(pet.getowner_id(), is(equalTo(ownerId)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntNullName() {
		new Pet(1, null, 2);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int ownerId = 2;
		
		final Pet pet = new Pet(id, "Laia", 2);
		pet.setPetName("Beethoven");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getpet_name(), is(equalTo("Beethoven")));
		assertThat(pet.getowner_id(), is(equalTo(ownerId)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet= new Pet(1, "Beethoven", 2);
		
		pet.setPetName(null);
	}

	@Test
	public void testSetOwnerId() {
		final int id = 1;
		final String name = "Beethoven";
		
		final Pet pet= new Pet(id, name, 2);
		pet.setOwnerId(6);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getpet_name(), is(equalTo(name)));
		assertThat(pet.getowner_id(), is(equalTo(6)));
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", 2);
		final Pet petB = new Pet(1, "Name B", 2);
		
		assertTrue(petB.equals(petA));
	}

//Error: cannot define class using reflection, downgradear java
	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("pet_name", "owner_id")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}
