var PetsView = (function() {
	var dao;
	var peopleDAO;
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	var self;
	
	var formId = 'pet-form';
	var listId = 'pet-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetsView(peopleDao, petsDao, formContainerId, listContainerId) {
		peopleDAO = peopleDao;
		dao = petsDao;
		var dict = {}
		self = this;
		
		insertPetsForm($('#' + formContainerId));
		insertPetsList($('#' + listContainerId));
		
		this.init = function() {
			dao.listPets(function(pet) {
				$.each(pet, function(key, pet) {
					appendToTable(pet);
				});
			},
			function() {
			    	alert('No has sido posible acceder al listado de mascotas.');
			});
			
			peopleDAO.listPeople(function(people) {
				$.each(people, function(key, people) {	
					 $('#pet_owner_select').append($("<option></option>").attr("value", people.id).text(people.name + ' ' +people.surname));
				});
			},
			function() {
			});
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {
				var pet = self.getPetInForm();
				console.log(pet);
				if (self.isEditing()) {
					dao.modifyPet(pet,
						function(pet) {
						console.log(pet);
							$('#pet-' + pet.id + ' td.pet_name').text(pet.pet_name);
							$('#pet-' + pet.id + ' td.owner_id').text(pet.owner_id);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addPet(pet,
						function(pet) {
							console.log(pet);
							appendToTable(pet);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
			
			$('#btnClear').click(this.resetForm);
		};
		
		this.reloadSelect = function(){
			$('#pet_owner_select').find('option').remove().end();
			peopleDAO.listPeople(function(people) {
					$.each(people, function(key, people) {	
						 $('#pet_owner_select').append($("<option></option>").attr("value", people.id).text(people.name + ' ' +people.surname));
					});
				},
				function() {
				});
		}
		
		this.getPetInForm = function() {
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
				'pet_name': form.find('input[name="pet_name"]').val(),
				'owner_id': $('#pet_owner_select option:selected').val()
			};
		};
		
	

		this.getPetInRow = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				return {
					'id': id,
					'pet_name': row.find('td.pet_name').text(),
					'owner_id': row.find('td.owner_id').text()
				};
			} else {
				return undefined;
			}
		};
		
		this.editPet = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				var form = $(formQuery);
				
				form.find('input[name="id"]').val(id);
				form.find('input[name="pet_name"]').val(row.find('td.pet_name').text());
				form.find('input[name="owner_id"]').val(row.find('td.owner_id').text());
				
				$('input#btnSubmit').val('Modificar');
			}
		};
		
		this.deletePet = function(id) {
			if (confirm('Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?')) {
				dao.deletePet(id,
					function() {
						$('tr#pet-' + id).remove();
					},
					showErrorMessage
				);
			}
		};

		this.isEditing = function() {
			return $(formQuery + ' input[name="id"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="id"]').val('');
			$('#btnSubmit').val('Crear');
		};
	};
	
	var insertPetsList = function(parent) {
		parent.append(
			'<table id="' + listId + '" class="table">\
				<thead>\
					<tr class="row">\
						<th class="col-sm-4">Nombre</th>\
						<th class="col-sm-5">Propietario</th>\
						<th class="col-sm-3">&nbsp;</th>\
					</tr>\
				</thead>\
				<tbody>\
				</tbody>\
			</table>'
		);
	};
	

	var insertPetsForm = function(parent) {
		parent.append(
			'<form id="' + formId + '" class="mb-5 mb-10">\
				<input name="id" type="hidden" value=""/>\
				<div class="row">\
					<div class="col-sm-4">\
						<input name="pet_name" type="text" value="" placeholder="Nombre" class="form-control" required/>\
					</div>\
					<div class="col-sm-5">\
						<select id="pet_owner_select" name="pet_owner" class="form-control">\
						</select>\
					</div>\
					<div class="col-sm-3">\
						<input id="btnSubmit" type="submit" value="Crear" class="btn btn-primary" />\
						<input id="btnClear" type="reset" value="Limpiar" class="btn" />\
					</div>\
				</div>\
			</form>'
		);
	};

	var createPetRow = function(pet) {
		return '<tr id="pet-'+ pet.id +'" class="row">\
			<td class="pet_name col-sm-4">' + pet.pet_name + '</td>\
			<td class="owner_id col-sm-5">' + pet.owner_id + '</td>\
			<td class="col-sm-3">\
				<a class="edit btn btn-primary" href="#">Editar</a>\
				<a class="delete btn btn-warning" href="#">Eliminar</a>\
			</td>\
		</tr>';
	};

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	};

	var addRowListeners = function(pet) {
		$('#pet-' + pet.id + ' a.edit').click(function() {
			self.editPet(pet.id);
		});
		
		$('#pet-' + pet.id + ' a.delete').click(function() {
			self.deletePet(pet.id);
		});
	};

	var appendToTable = function(pet) {
		$(listQuery + ' > tbody:last')
			.append(createPetRow(pet));
		addRowListeners(pet);
	};
	
	return PetsView;
})();
