package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

public class Pet {
	private int id;
	private String pet_name;
	private int owner_id;
	
	public Pet() {} //Constructor para la conversion JSON
	
	public Pet(int id, String pet_name, int owner_id){
		this.id = id;
		this.setPetName(pet_name);
		this.setOwnerId(owner_id);
	}
	
	public int getId() {
		return this.id;
	}
	
	public String getpet_name(){
		return this.pet_name;
	}
	
	public int getowner_id() {
		return this.owner_id;
	}
	
	public void setPetName(String pet_name) {
		this.pet_name = requireNonNull(pet_name, "Pet name can't be null");
	}
	
	public void setOwnerId(int owner_id) {
		this.owner_id = requireNonNull(owner_id, "Owner id can´t be null");
	}
	
	public void setPetId(int id) {
		this.id = id;
	}
	@Override
	public String toString() {
		StringBuilder toret = new StringBuilder();
		toret.append("Id: ").append(getId()).append("\n");
		toret.append("Nombre: ").append(getpet_name()).append("\n");
		toret.append("Owner id: ").append(getowner_id()).append("\n");
		return toret.toString();
		
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
	
}
