package es.uvigo.esei.daa.entities;

/**
 * Created by Alex on 07/03/2017.
 */

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {


    @Test
    public void testPetIntStringStringInt() {
        final int id = 1;
        final String name = "Jackye";
        final String breed = "Pitbull";
        final int idOwner = 1;

        final Pet pet = new Pet(id, name, breed, idOwner);

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo(name)));
        assertThat(pet.getBreed(), is(equalTo(breed)));
        assertThat(pet.getIdOwner(), is(equalTo(idOwner)));
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringIntNullName() {
        new Pet(1, null, "Pitbull", 1);
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringIntNullBreed() {
        new Pet(1, "Jackye", null, 1);
    }

    @Test
    public void testSetName() {
        final int id = 1;
        final String breed = "Doe";
        final int idOwner = 1;

        final Pet pet = new Pet(id, "John", breed, idOwner);
        pet.setName("Juan");

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo("Juan")));
        assertThat(pet.getBreed(), is(equalTo(breed)));
    }

    @Test(expected = NullPointerException.class)
    public void testSetNullName() {
        final Pet pet = new Pet(1, "John", "Doe", 1);

        pet.setName(null);
    }

    @Test
    public void testSetBreed() {
        final int id = 1;
        final String name = "Jackye";
        final int idOwner = 1;

        final Pet pet = new Pet(id, name, "Chiwaka", 1);
        pet.setBreed("Pitbull");

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo(name)));
        assertThat(pet.getBreed(), is(equalTo("Pitbull")));
        assertThat(pet.getIdOwner(), is(equalTo(idOwner)));
    }

    @Test(expected = NullPointerException.class)
    public void testSetNullBreed() {
        final Pet pet = new Pet(1, "John", "Doe", 1);

        pet.setBreed(null);
    }

    @Test
    public void testEqualsObject() {
        final Pet petA = new Pet(1, "Name A", "Breed A",1);
        final Pet petB = new Pet(1, "Name B", "Breed B", 2);

        assertTrue(petA.equals(petB));
    }

    @Test
    public void testEqualsHashcode() {
        EqualsVerifier.forClass(Pet.class)
                .withIgnoredFields("name", "breed", "idOwner")
                .suppress(Warning.STRICT_INHERITANCE)
                .suppress(Warning.NONFINAL_FIELDS)
                .verify();
    }
}