package es.uvigo.esei.daa.dataset;

/**
 * Created by Alex on 08/03/2017.
 */

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public class PetDataset {
    private PetDataset() {}

    public static Pet[] pets() {
        return new Pet[] {
                new Pet(1, "Jackye", "Pitbull", 1),
                new Pet(2, "Robert", "Persian cat", 2),
                new Pet(3, "Miles", "Hot dog", 3),
        };
    }

    public static Pet[] petsWithout(int ... ids) {
        Arrays.sort(ids);

        final Predicate<Pet> hasValidId = pets ->
                binarySearch(ids, pets.getId()) < 0;

        return stream(pets())
                .filter(hasValidId)
                .toArray(Pet[]::new);
    }

    public static Pet pet(int id) {
        return stream(pets())
                .filter(pets -> pets.getId() == id)
                .findAny()
                .orElseThrow(IllegalArgumentException::new);
    }

    public static int existentId() {
        return 5;
    }

    public static int nonExistentId() {
        return 1234;
    }

    public static Pet existentPet() {
        return pet(existentId());
    }

    public static Pet nonExistentPet() {
        return new Pet(nonExistentId(), "Pico Pato", "Bird", 1);
    }

    public static String newName() {
        return "Jackye";
    }

    public static String newBreed() {
        return "Pitbull";
    }

    public static int newIdOwner() {
        return 1;
    }

    public static Pet newPet() {
        return new Pet(pets().length + 1, newName(), newBreed(), newIdOwner());
    }
}
