package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * Created by Alex on 15/02/2017.
 */

public class Pet {
    private int id;
    private String name;
    private String breed;
    private int idOwner;

    // Constructor needed for the JSON conversion
    Pet() {}

    /**
     * Constructs a new instance of {@link Pet}.
     *
     * @param id identifier of the pet.
     * @param name name of the pet.
     * @param breed breed of the pet.
     */
    public Pet(int id, String name, String breed, int idOwner) {
        this.id = id;
        this.setName(name);
        this.setBreed(breed);
        this.setIdOwner(idOwner);
    }

    /**
     * Returns the identifier of the pet.
     *
     * @return the identifier of the pet.
     */
    public int getId() {
        return id;
    }

    /**
     * Returns the identifier of the owner.
     *
     * @return the identifier of the owner.
     */
    public int getIdOwner() {
        return idOwner;
    }

    public void setIdOwner(int i) {
        this.idOwner = i;
    }

    /**
     * Returns the name of the pet.
     *
     * @return the name of the pet.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name of this pet.
     *
     * @param name the new name of the pet.
     * @throws NullPointerException if the {@code name} is {@code null}.
     */
    public void setName(String name) {
        this.name = requireNonNull(name, "Name can't be null");
    }

    /**
     * Returns the breed of the pet.
     *
     * @return the breed of the pet.
     */
    public String getBreed() {
        return breed;
    }

    /**
     * Set the breed of this pet.
     *
     * @param breed the new breed of the pet.
     * @throws NullPointerException if the {@code breed} is {@code null}.
     */
    public void setBreed(String breed) {
        this.breed = requireNonNull(breed, "Breed can't be null");
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Pet))
            return false;
        Pet other = (Pet) obj;
        if (id != other.getId())
            return false;
        return true;
    }
}