/**
 * Created by Alex on 15/02/2017.
 */
var PetsView = (function() {
    var dao;
    var peopleDAO;

    // Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
    var self;

    var formId = 'pets-form';
    var listId = 'pets-list';
    var formQuery = '#' + formId;
    var listQuery = '#' + listId;

    function PetsView(petsDao, peopleDao, formContainerId, listContainerId) {
        dao = petsDao;
        peopleDAO = peopleDao;
        self = this;

        insertPetsForm($('#' + formContainerId));
        insertPetsList($('#' + listContainerId));

        this.init = function() {
            dao.listPets(function(pets) {
                $.each(pets, function(key, pet) {
                    appendToTable(pet);
                });
            });

            // La acción por defecto de enviar formulario (submit) se sobreescribe
            // para que el envío sea a través de AJAX
            $(formQuery).submit(function(event) {
                var pet = self.getPetInForm();

                if (self.isEditing()) {
                    dao.modifyPet(pet,
                        function(pet) {
                            $('#pet-' + pet.id + ' td.name').text(pet.name);
                            $('#pet-' + pet.id + ' td.breed').text(pet.breed);
                            $('#pet-' + pet.id + ' td.idOwner').text(pet.idOwner);
                            self.resetForm();
                        },
                        showErrorMessage,
                        self.enableForm
                    );
                } else {
                    dao.addPet(pet,
                        function(pet) {
                            appendToTable(pet);
                            self.resetForm();
                        },
                        showErrorMessage,
                        self.enableForm
                    );
                }

                return false;
            });

            $('#btnClear').click(this.resetForm);
        };

        this.getPetInForm = function() {
            var form = $(formQuery);
            return {
                'id': form.find('input[name="id"]').val(),
                'name': form.find('input[name="name"]').val(),
                'breed': form.find('input[name="breed"]').val(),
                'idOwner': form.find('input[name="idOwner"]').val()
            };
        };

        this.getPetInRow = function(id) {
            var row = $('#pet-' + id);

            if (row !== undefined) {
                return {
                    'id': id,
                    'name': row.find('td.name').text(),
                    'breed': row.find('td.breed').text(),
                    'idOwner': row.find('td.idOwner').text()
                };
            } else {
                return undefined;
            }
        };

        this.editPet = function(id) {
            var row = $('#pet-' + id);

            console.log(row);
            if (row !== undefined) {
                var form = $(formQuery);
                console.log(form);
                console.log(row.find('td.name').text());
                console.log(row.find('td.breed').text());
                console.log(row.find('td.idOwner').text());

                form.find('input[name="id"]').val(id);
                form.find('input[name="name"]').val(row.find('td.name').text());
                form.find('input[name="breed"]').val(row.find('td.breed').text());
                form.find('input[name="idOwner"]').val(row.find('td.idOwner').text());
            }
        }

        this.isEditing = function() {
            return $(formQuery + ' input[name="id"]').val() != "";
        };

        this.disableForm = function() {
            $(formQuery + ' input').prop('disabled', true);
        };

        this.enableForm = function() {
            $(formQuery + ' input').prop('disabled', false);
        };

        this.resetForm = function() {
            $(formQuery)[0].reset();
            $(formQuery + ' input[name="id"]').val('');
            $('#btnSubmit').val('Crear');
        };
    }

    var insertPetsList = function(parent) {
        parent.append(
            '<table id="' + listId + '">\
				<tr>\
					<th>Nombre</th>\
					<th>Raza</th>\
					<th>Owner</th>\
					<th></th>\
				</tr>\
			</table>'
        );
    }

    var insertPetsForm = function(parent) {

        var l = peopleDAO.listPeople();

        parent.append(
            '<form id="' + formId + '">\
				<input name="id" type="hidden" value=""/>\
				<input name="name" type="text" value="" />\
				<input name="breed" type="text" value=""/>\
				<select>\n\
                    <option name="id" value="' + l[i].$1 + '">' + l[i].$2 + '</option>\n\
                </select>\
				<input name="idOwner" type="text" value=""/>\
				<input id="btnSubmit" type="submit" value="Create"/>\
				<input id="btnClear" type="reset" value="Limpiar"/>\
			</form>'
        );
    }

    var createPetRow = function(pet) {
        return '<tr id="pet-'+ pet.id +'">\
			<td class="name">' + pet.name + '</td>\
			<td class="breed">' + pet.breed + '</td>\
			<td class="idOwner">' + pet.idOwner + '</td>\
			<td>\
				<a class="edit" href="#">Edit</a>\
			</td>\
			<td>\
				<a class="delete" href="#">Delete</a>\
			</td>\
		</tr>';
    }

    var showErrorMessage = function(jqxhr, textStatus, error) {
        alert(textStatus + ": " + error);
    }

    var addRowListeners = function(pet) {
        $('#pet-' + pet.id + ' a.edit').click(function() {
            self.editPet(pet.id);
            $('input#btnSubmit').val('Modificar');
        });

        $('#pet-' + pet.id + ' a.delete').click(function() {
            if (confirm('Está a punto de eliminar a una peta. ¿Está seguro de que desea continuar?')) {
                dao.deletePet(pet.id,
                    function() {
                        $('tr#pet-' + pet.id).remove();
                    },
                    showErrorMessage
                );
            }
        });
    }

    var appendToTable = function(pet) {
        $(listQuery + ' > tbody:last')
            .append(createPetRow(pet));
        addRowListeners(pet);
    }

    return PetsView;
})();