package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
    @Test
    public void testPetIntStringStringInt(){
        final int id = 1;
        final String name = "Boby";
        final String type = "dog";
        final int person = 1;

        final Pet pet = new Pet(id,name,type,person);

        assertThat(pet.getId(),is(equalTo(id)));
        assertThat(pet.getName(),is(equalTo(name)));
        assertThat(pet.getType(),is(equalTo(type)));
        assertThat(pet.getPerson(),is(equalTo(person)));
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringIntNullName() {
        new Pet(1, null, "dog",1);
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringIntNullType() {
        new Pet(1, "Boby", null,1);
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringIntNullPerson() {
        Integer person = null;
        new Pet(1, "John", "dog",person);
    }

    @Test
    public void testSetName() {
        final int id = 1;
        final String type = "Dog";

        final Pet pet = new Pet(id, "Boby", type,id);
        pet.setName("Juan");

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo("Juan")));
        assertThat(pet.getType(), is(equalTo(type)));
    }

    @Test(expected = NullPointerException.class)
    public void testSetNullType() {
        final Pet pet = new Pet(1, "Boby", "Dog",1);

        pet.setType(null);
    }

    @Test
    public void testEqualsObject() {
        final Pet petA = new Pet(1, "Name A", "Surname A",1);
        final Pet petB = new Pet(1, "Name B", "Surname B",1);

        assertTrue(petA.equals(petB));
    }

    @Test
    public void testEqualsHashcode() {
        EqualsVerifier.forClass(Pet.class)
                .withIgnoredFields("name", "type", "person")
                .suppress(Warning.STRICT_INHERITANCE)
                .suppress(Warning.NONFINAL_FIELDS)
                .verify();
    }
}
