package es.uvigo.esei.daa.dataset;

import es.uvigo.esei.daa.entities.Pet;

import java.util.Arrays;
import java.util.function.Predicate;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

public class PetsDataset {
    private PetsDataset(){}

    public static Pet[] pets(){
        return new Pet[]{
                new Pet(1,"perro1","dog",1),
                new Pet(2,"perro2","dog",2),
                new Pet(3,"perro3","dog",3),
                new Pet(4,"perro4","dog",4),
                new Pet(5,"perro5","dog",5),
                new Pet(6,"perro6","dog",6),
                new Pet(7,"perro7","dog",7),
                new Pet(8,"perro8","dog",8),
                new Pet(9,"perro9","dog",9),
                new Pet(10,"perro10","dog",10)
        };
    }
    public static Pet[] petsWithout(int ... ids) {
        Arrays.sort(ids);

        final Predicate<Pet> hasValidId = pet ->
                binarySearch(ids, pet.getId()) < 0;

        return stream(pets())
                .filter(hasValidId)
                .toArray(Pet[]::new);
    }

    public static Pet pet(int id) {
        return stream(pets())
                .filter(pet -> pet.getId() == id)
                .findAny()
                .orElseThrow(IllegalArgumentException::new);
    }
    public static int existentId() {
        return 5;
    }
    public static int existentOwner(){
        return 5;
    }

    public static int nonExistentId() {
        return 1234;
    }

    public static Pet existentPet() {
        return pet(existentId());
    }

    public static Pet nonExistentPet() {
        return new Pet(nonExistentId(), "perro1", "dog",1);
    }

    public static String newName() {
        return "perro11";
    }

    public static String newType() {
        return "dog";
    }
    public static int newPerson() {
        return 11;
    }

    public static Pet newPet() {
        return new Pet(pets().length + 1, newName(), newType(),newPerson());
    }
}


