package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * An entity that represents a pet
 *
 * @author albovy
 */
public class Pet {
    private int id;
    private String name;
    private String type;
    private int person;

    //Constructor needed for JSON conversion
    Pet(){}

    /**
     * Constructs a new instance of {@link Pet}.
     *
     * @param id identifier of the pet.
     * @param name name of the pet.
     * @param type specie of the pet.
     * @param person owner of the pet.
     */
    public Pet(int id, String name, String type, int person) {
        this.id = id;
        this.setName(name);
        this.setType(type);
        this.person = person;
    }

    /**
     * Returns the identifier of the pet.
     *
     * @return the identifier of the pet.
     */
    public int getId() {
        return id;
    }
    /**
     * Returns the name of the pet.
     *
     * @return the name of the pet.
     */
    public String getName() {
        return name;
    }
    /**
     * Returns the specie of the pet.
     *
     * @return the specie of the pet.
     */
    public String getType() {
        return type;
    }
    /**
     * Returns the owner of the pet.
     *
     * @return the owner of the pet.
     */
    public int getPerson() {
        return person;
    }
    /**
     * Set the name of this pet.
     *
     * @param name the new name of the pet.
     * @throws NullPointerException if the{@code name} is {@code null}.
     */
    public void setName(String name) {
        this.name = requireNonNull(name,"Name can't be null");
    }
    /**
     * Set the specie of the pet.
     *
     * @param type the new specie of the pet.
     * @throws NullPointerException if the{@code type} is {@code null}.
     */
    public void setType(String type) {
        this.type = requireNonNull(type,"Type can't be null");
    }

    /**
     * Set the owner of the pet.
     *
     * @param person the owner of the pet
     * @throws  NullPointerException if the {@code person} is {@code null}
     */
    public void setPerson(Integer person){
        this.person = requireNonNull(person,"Person can't be null");
    }

    @Override
    public int hashCode(){
        final int prime = 31;
        int result = 1;
        result = prime * result + id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Pet))
            return false;
        Pet other = (Pet) obj;
        if (id != other.id)
            return false;
        return true;
    }
}
