class PetsDAO {
    resourcePath;

    constructor(){
        this.resourcePath = "rest/pets/";
    }

    requestByAjax(data, done, fail, always){
        done = typeof done !== 'undefined' ? done : function () {
        };
        fail = typeof fail !== 'undefined' ? fail : function () {
        };
        always = typeof always !== 'undefined' ? always : function () {
        };

        let authToken = localStorage.getItem('authorization-token');
        if (authToken !== null) {
            data.beforeSend = function (xhr) {
                xhr.setRequestHeader('Authorization', 'Basic ' + authToken);
            };
        }

        $.ajax(data).done(done).fail(fail).always(always);
    }

    listPets(done,fail,always) {
        this.requestByAjax({
            url : this.resourcePath,
            type : 'GET'
        }, done,fail,always);
    }
    listPetsOwner(id,done,fail,always){
        this.requestByAjax({
            url : this.resourcePath + "?idPeople=" + id,
            type : 'GET'
        },done,fail,always);
    }
    addPet(pet,done,fail,always){
        this.requestByAjax({
            url : this.resourcePath,
            type : 'POST',
            data : pet
        }, done, fail, always);
    }
    modifyPet(pet,done,fail,always){
        this.requestByAjax({
            url : this.resourcePath + pet.id,
            type : 'PUT',
            data : pet
        },done,fail,always);
    }
    deletePet(id,done,fail,always){
        this.requestByAjax({
            url : this.resourcePath + id,
            type : 'DELETE'
        },done,fail,always);
    }

}






