/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextUtilities {
    public static int findMatchingBracket(Document doc, int offset) throws BadLocationException {
        boolean direction;
        char cprime;
        if (doc.getLength() == 0) {
            return -1;
        }
        char c = doc.getText(offset, 1).charAt(0);
        switch (c) {
            case '(': {
                cprime = ')';
                direction = false;
                break;
            }
            case ')': {
                cprime = '(';
                direction = true;
                break;
            }
            case '[': {
                cprime = ']';
                direction = false;
                break;
            }
            case ']': {
                cprime = '[';
                direction = true;
                break;
            }
            case '{': {
                cprime = '}';
                direction = false;
                break;
            }
            case '}': {
                cprime = '{';
                direction = true;
                break;
            }
            default: {
                return -1;
            }
        }
        if (direction) {
            int count = 1;
            String text = doc.getText(0, offset);
            int i = offset - 1;
            while (i >= 0) {
                char x = text.charAt(i);
                if (x == c) {
                    ++count;
                } else if (x == cprime && --count == 0) {
                    return i;
                }
                --i;
            }
        } else {
            int count = 1;
            int len = doc.getLength() - ++offset;
            String text = doc.getText(offset, len);
            int i = 0;
            while (i < len) {
                char x = text.charAt(i);
                if (x == c) {
                    ++count;
                } else if (x == cprime && --count == 0) {
                    return i + offset;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int findWordStart(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos - 1);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordStart = 0;
        int i = pos - 1;
        while (i >= 0) {
            ch = line.charAt(i);
            if (selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1)) {
                wordStart = i + 1;
                break;
            }
            --i;
        }
        return wordStart;
    }

    public static int findWordEnd(String line, int pos, String noWordSep) {
        char ch = line.charAt(pos);
        if (noWordSep == null) {
            noWordSep = "";
        }
        boolean selectNoLetter = !Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1;
        int wordEnd = line.length();
        int i = pos;
        while (i < line.length()) {
            ch = line.charAt(i);
            if (selectNoLetter ^ (!Character.isLetterOrDigit(ch) && noWordSep.indexOf(ch) == -1)) {
                wordEnd = i;
                break;
            }
            ++i;
        }
        return wordEnd;
    }
}

