/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.editor;

import java.util.Stack;
import java.util.Vector;
import javatraceit.gui.depurador.editor.SyntaxDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class JTIUndoableSyntaxDocument
extends SyntaxDocument {
    private static final int MAX_UNDOABLE = 5000;
    private Vector pilaUndo = new Stack();
    private Vector undosAInsertar = new Vector();
    private boolean estoyEnCompoundEdit = false;
    private boolean haciendoUndo = false;
    AttributeSet atributos = null;

    public void beginCompoundEdit() {
        this.estoyEnCompoundEdit = true;
        this.undosAInsertar = new Vector();
    }

    public void endCompoundEdit() {
        this.estoyEnCompoundEdit = false;
        this.pilaUndo.add(0, this.undosAInsertar);
        if (this.pilaUndo.size() == 5000) {
            this.pilaUndo.remove(this.pilaUndo.size() - 1);
        }
    }

    public void addUndoableEdit(UndoableEdit edit) {
        if (this.haciendoUndo) {
            return;
        }
        if (this.estoyEnCompoundEdit) {
            this.undosAInsertar.add(0, edit);
        } else {
            if (!(edit instanceof UndoRemove) && !(edit instanceof UndoInsert)) {
                return;
            }
            this.undosAInsertar = new Vector();
            this.undosAInsertar.add(edit);
            this.pilaUndo.add(0, this.undosAInsertar);
            if (this.pilaUndo.size() == 5000) {
                this.pilaUndo.remove(this.pilaUndo.size() - 1);
            }
            this.undosAInsertar = new Vector();
        }
    }

    public void removeUndos() {
        this.pilaUndo = new Stack();
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.addUndoableEdit(new UndoInsert(offset, str, a));
    }

    public void remove(int offs, int len) {
        try {
            this.addUndoableEdit(new UndoRemove(offs, len));
            super.remove(offs, len);
        }
        catch (Exception ex) {}
    }

    public void undo() {
        this.haciendoUndo = true;
        try {
            if (this.pilaUndo.size() <= 0) {
                this.haciendoUndo = false;
                return;
            }
            Vector undos = (Vector)this.pilaUndo.elementAt(0);
            this.pilaUndo.remove(0);
            while (undos.size() > 0) {
                try {
                    ((UndoableEdit)undos.elementAt(0)).undo();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                undos.remove(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.haciendoUndo = false;
    }

    class UndoRemove
    extends AbstractUndoableEdit {
        private int principio;
        private int longitud;
        private String cadena;

        public UndoRemove(int offset, int len) {
            this.principio = offset;
            this.longitud = len;
            try {
                this.cadena = JTIUndoableSyntaxDocument.this.getText(offset, len);
            }
            catch (Exception ex) {
                this.cadena = "";
            }
        }

        public void undo() {
            try {
                JTIUndoableSyntaxDocument.super.insertString(this.principio, this.cadena, JTIUndoableSyntaxDocument.this.atributos);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class UndoInsert
    extends AbstractUndoableEdit {
        private int principio;
        private int longitud;

        public UndoInsert(int offset, String str, AttributeSet a) {
            this.principio = offset;
            this.longitud = str.length();
            JTIUndoableSyntaxDocument.this.atributos = a;
        }

        public void undo() {
            try {
                JTIUndoableSyntaxDocument.super.remove(this.principio, this.longitud);
            }
            catch (Exception ex) {}
        }
    }
}

