/*
 * Decompiled with CFR 0.152.
 */
package javatraceit.gui.depurador.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javatraceit.gui.depurador.editor.JTITextArea;
import javatraceit.gui.depurador.editor.TextAreaDefaults;
import javatraceit.gui.depurador.editor.TextAreaPainter;
import javatraceit.gui.depurador.editor.TokenMarker;

public class JTITextAreaPainter
extends TextAreaPainter {
    private Color breakpointColor;
    private Color tracelineColor;
    private int lineaDestacada = -1;
    private Vector breakpoints = new Vector();

    public JTITextAreaPainter(JTITextArea textArea, TextAreaDefaults defaults) {
        super(textArea, defaults);
        this.breakpointColor = defaults.breakpointHighlightColor;
        this.tracelineColor = defaults.traceHighlightColor;
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
            }
        });
    }

    public int getLineaDestacada() {
        return this.lineaDestacada;
    }

    protected void paintLine(Graphics gfx, TokenMarker tokenMarker, int line, int x) {
        Font defaultFont = this.getFont();
        Color defaultColor = this.getForeground();
        this.currentLineIndex = line;
        int y = this.textArea.lineToY(line);
        if (line < 0 || line >= this.textArea.getLineCount()) {
            if (this.paintInvalid) {
                this.paintHighlight(gfx, line, y);
                this.styles[10].setGraphicsFlags(gfx, defaultFont);
                gfx.drawString("~", 0, y + this.fm.getHeight());
            }
        } else if (tokenMarker == null) {
            this.paintPlainLine(gfx, line, defaultFont, defaultColor, x, y);
        } else {
            this.paintSyntaxLine(gfx, tokenMarker, line, defaultFont, defaultColor, x, y);
        }
    }

    public void paint(Graphics gfx) {
        this.tabSize = this.fm.charWidth(' ') * (Integer)this.textArea.getDocument().getProperty("tabSize");
        Rectangle clipRect = gfx.getClipBounds();
        gfx.setColor(this.getBackground());
        gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        int height = this.fm.getHeight();
        int firstLine = this.textArea.getFirstLine();
        int firstInvalid = firstLine + clipRect.y / height;
        int lastInvalid = firstLine + (clipRect.y + clipRect.height - 1) / height;
        try {
            TokenMarker tokenMarker = this.textArea.getDocument().getTokenMarker();
            int x = this.textArea.getHorizontalOffset();
            ((JTITextArea)this.textArea).numLineas.repaint(firstLine, firstLine + this.getBounds().height / height);
            int line = firstInvalid;
            while (line <= lastInvalid) {
                this.paintLine(gfx, tokenMarker, line, x);
                ++line;
            }
            if (tokenMarker != null && tokenMarker.isNextLineRequested()) {
                int h = clipRect.y + clipRect.height;
                this.repaint(0, h, this.getWidth(), this.getHeight() - h);
            }
        }
        catch (Exception e) {
            System.err.println("Error repainting line range {" + firstInvalid + "," + lastInvalid + "}:");
            e.printStackTrace();
        }
    }

    protected void paintHighlight(Graphics gfx, int line, int y) {
        if (line >= this.textArea.getSelectionStartLine() && line <= this.textArea.getSelectionEndLine()) {
            this.paintLineHighlight(gfx, line, y);
        }
        if (this.breakpoints.indexOf(new Integer(line)) != -1) {
            this.paintBreakpointLine(gfx, line, y);
        }
        if (line + 1 == this.lineaDestacada) {
            this.paintTraceLine(gfx, line, y);
        }
        if (this.highlights != null) {
            this.highlights.paintHighlight(gfx, line, y);
        }
        if (this.bracketHighlight && line == this.textArea.getBracketLine()) {
            this.paintBracketHighlight(gfx, line, y);
        }
        if (line == this.textArea.getCaretLine()) {
            this.paintCaret(gfx, line, y);
        }
    }

    public void setLineaDestacada(int linea) {
        this.lineaDestacada = linea;
        this.repaint();
    }

    public void sacarLineaDestacada() {
        this.lineaDestacada = -1;
        this.repaint();
    }

    public boolean toggleBreakpoint(int linea) {
        int pos = this.breakpoints.indexOf(new Integer(linea));
        if (pos != -1) {
            this.breakpoints.remove(pos);
            this.repaint();
            return false;
        }
        this.breakpoints.add(new Integer(linea));
        this.repaint();
        return true;
    }

    public void sacarTodosLosBreakpoints() {
        this.breakpoints = new Vector();
        this.repaint();
    }

    public Vector getBreakpoints() {
        return this.breakpoints;
    }

    protected void paintBreakpointLine(Graphics gfx, int line, int y) {
        int height = this.fm.getHeight();
        int selectionStart = this.textArea.getSelectionStart();
        int selectionEnd = this.textArea.getSelectionEnd();
        gfx.setColor(this.breakpointColor);
        gfx.fillRect(0, y += this.fm.getLeading() + this.fm.getMaxDescent(), this.getWidth(), height);
    }

    protected void paintTraceLine(Graphics gfx, int line, int y) {
        int height = this.fm.getHeight();
        int selectionStart = this.textArea.getSelectionStart();
        int selectionEnd = this.textArea.getSelectionEnd();
        gfx.setColor(this.tracelineColor);
        gfx.fillRect(0, y += this.fm.getLeading() + this.fm.getMaxDescent(), this.getWidth(), height);
    }
}

